'From Squeak3.8 of ''5 May 2005'' [latest update: #6665] on 8 September 2005 at 3:07:58 pm'!
SmartSyntaxInterpreterPlugin subclass: #ServicesPlugin
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'VMMaker-Plugins'!

!ServicesPlugin methodsFor: 'initialize' stamp: 'JMM 6/12/2005 11:17'!
initialiseModule
	self export: true.
	^self sqServicesInitialize ! !

!ServicesPlugin methodsFor: 'initialize' stamp: 'JMM 6/12/2005 11:17'!
moduleUnloaded: aModuleName 
	"The module with the given name was just unloaded. 
	Make sure we have no dangling references."
	self export: true.
	self var: #aModuleName type: 'char *'.
	(aModuleName strcmp: 'ServicesPlugin') = 0
		ifTrue: [self sqServicesShutdown]! !

!ServicesPlugin methodsFor: 'initialize' stamp: 'JMM 9/8/2005 09:21'!
primitiveGetBytes
	"Setup bytes, could be text, could be TIFF"
	| length oop |

	self primitive: 'primitiveGetBytes'.
	length := self sqServicesGetTextStringLength.
	oop := interpreterProxy instantiateClass: interpreterProxy classByteArray indexableSize: length.
	self sqServicesGetTextStringInto: (interpreterProxy firstIndexableField: oop).
	^oop

! !

!ServicesPlugin methodsFor: 'initialize' stamp: 'JMM 6/12/2005 13:11'!
primitiveGetTextString
	"Setup text string"
	| length oop |

	self primitive: 'primitiveGetTextString'.
	length := self sqServicesGetTextStringLength.
	oop := interpreterProxy instantiateClass: interpreterProxy classString indexableSize: length.
	self sqServicesGetTextStringInto: (interpreterProxy firstIndexableField: oop).
	^oop

! !

!ServicesPlugin methodsFor: 'initialize' stamp: 'JMM 9/8/2005 09:23'!
primitiveSetBytes: aTextString
	"Setup text string"
	| dataTypesLength |

	self primitive: 'primitiveSetBytes'
		parameters: #(ByteArray).
	dataTypesLength := interpreterProxy slotSizeOf: aTextString cPtrAsOop.
	self sqServicesSetTextString:   aTextString length: dataTypesLength.

! !

!ServicesPlugin methodsFor: 'initialize' stamp: 'JMM 9/8/2005 09:40'!
primitiveSetCopyOSTypeString: aTextString
	"Setup copy ostype string"

	self primitive: 'primitiveSetCopyOSTypeString'
		parameters: #(String).
	self sqServicesSetCopyOSTypeString:   aTextString.

! !

!ServicesPlugin methodsFor: 'initialize' stamp: 'JMM 6/12/2005 11:25'!
primitiveSetDataTypes: dataTypes
	"OSType MyAppsDataTypes[] ='TEXT','PICT','MooV','AIFF','utxt'}; "
	| dataTypesLength |

	self primitive: 'primitiveSetDataTypes'
		parameters: #(String).
	dataTypesLength := interpreterProxy slotSizeOf: dataTypes cPtrAsOop.
	self sqServicesSetDataTypes:   dataTypes length: dataTypesLength.

! !

!ServicesPlugin methodsFor: 'initialize' stamp: 'JMM 9/8/2005 09:40'!
primitiveSetPasteOSTypeString: aTextString
	"Setup paste ostype string"

	self primitive: 'primitiveSetPasteOSTypeString'
		parameters: #(String).
	self sqServicesSetPasteOSTypeString:   aTextString.

! !

!ServicesPlugin methodsFor: 'initialize' stamp: 'JMM 9/8/2005 09:41'!
primitiveSetPerformOSTypeString: aTextString
	"Setup perform ostype string"

	self primitive: 'primitiveSetPerformOSTypeString'
		parameters: #(String).
	self sqServicesSetPerformOSTypeString:   aTextString.

! !

!ServicesPlugin methodsFor: 'initialize' stamp: 'JMM 9/8/2005 09:19'!
primitiveSetReturnBytes: aByteArray osType: aOSType
	"Setup text string"
	| dataTypesLength |

	self primitive: 'primitiveSetReturnBytes'
		parameters: #(ByteArray String).
	dataTypesLength := interpreterProxy slotSizeOf: aByteArray cPtrAsOop.
	self sqServicesSetBytes:   aByteArray length: dataTypesLength osType: aOSType.

! !

!ServicesPlugin methodsFor: 'initialize' stamp: 'JMM 6/12/2005 15:13'!
primitiveSetReturnTextString: aTextString
	"Setup text string"
	| dataTypesLength |

	self primitive: 'primitiveSetReturnTextString'
		parameters: #(String).
	dataTypesLength := interpreterProxy slotSizeOf: aTextString cPtrAsOop.
	self sqServicesSetReturnTextString:   aTextString length: dataTypesLength.

! !

!ServicesPlugin methodsFor: 'initialize' stamp: 'JMM 6/12/2005 11:33'!
primitiveSetSemaphore: semi

	self primitive: 'primitiveSetSemaphore'
		parameters: #(SmallInteger).
	self sqServicesSetSemaphore:  semi.

! !

!ServicesPlugin methodsFor: 'initialize' stamp: 'JMM 6/12/2005 11:44'!
primitiveSetTextString: aTextString
	"Setup text string"
	| dataTypesLength |

	self primitive: 'primitiveSetTextString'
		parameters: #(String).
	dataTypesLength := interpreterProxy slotSizeOf: aTextString cPtrAsOop.
	self sqServicesSetTextString:   aTextString length: dataTypesLength.

! !


!ServicesPlugin class methodsFor: 'translation' stamp: 'JMM 9/8/2005 09:48'!
hasHeaderFile
	"If there is a single intrinsic header file to be associated with the plugin, here is where you want to flag"
	^true! !

!ServicesPlugin class methodsFor: 'translation' stamp: 'JMM 9/8/2005 09:52'!
requiresCrossPlatformFiles
	"default is ok for most, any plugin needing platform specific files must say so"
	^false! !

!ServicesPlugin class methodsFor: 'translation' stamp: 'JMM 6/12/2005 13:12'!
requiresPlatformFiles
	"this plugin requires platform specific files in order to work"
	^true! !


!ServicesPlugin class reorganize!
('translation' hasHeaderFile requiresCrossPlatformFiles requiresPlatformFiles)
!


!ServicesPlugin reorganize!
('initialize' initialiseModule moduleUnloaded: primitiveGetBytes primitiveGetTextString primitiveSetBytes: primitiveSetCopyOSTypeString: primitiveSetDataTypes: primitiveSetPasteOSTypeString: primitiveSetPerformOSTypeString: primitiveSetReturnBytes:osType: primitiveSetReturnTextString: primitiveSetSemaphore: primitiveSetTextString:)
!

